package cn.com.duiba.tuia.algo.engine.api.adx;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * adx 流量预过滤结果
 *
 * @author peanut.huang
 * @date 2020/3/23
 * @since JDK 1.8
 */
@Data
@Accessors(chain = true)
public class AdxFlowFilterResult implements Serializable {

    private static final long serialVersionUID = 2350642616640270733L;

    /**
     * 流量过滤标记（0：不过滤；1：过滤）
     */
    Integer flowFilterLabel;

    /**
     * ctr预估区间
     */
    Integer preInterval;

    /**
     * abtest分流标记（1：对比组；2：测试组）
     */
    Integer filterIndex;

    /**
     * 流量创意预估价格
     */
    private Double predictPrice;
}
