package cn.com.duiba.tuia.algo.engine.api.adx;

import cn.com.duiba.tuia.activity.center.api.constant.adx.PriceType;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * Description: 算法出价流量特征对象
 *
 * @author hillchen
 * @create 2019/2/26 14:10
 */
public class BidFlowFeature implements Serializable {
    private String adxRid;
    private String tagId;
    private String imei;
    private String ip;
    private String ua;
    private String os;

    private String cat;
    private String tuiaCat;
    private String sectionCat;
    private String tuiaSectionCat;
    private String keywords;

    private Integer posType;
    private Integer posStyle;
    private Integer resourcePicH;
    private Integer resourcePicW;

    private Long areaCode;
    private Integer deviceType;
    private Integer tuiaDeviceType;
    private String make;
    private String model;
    private String carrier;
    private Integer connectionType;
    private Integer tuiaConnectionType;
    private Float lat;
    private Float lon;
    private Long currentCreatTime;

    private String gender;

    /** 底价(分/千次曝光) 来源：adx请求 */
    private Double basePrice;

    /** 策略标记 */
    private String strategy;

    //新增adx流量特征
    //用户
    /** 用户兴趣 f5010020 */
    private String interestKeyWords;

    /** 出生年月 f5010030 */
    private String yob;

    //上下文-新增
    /** 应用名称 f6010010 */
    private String appName;

    /** 包名 f6010020 */
    private String appBundle;

    /** 应用当前页类型 f6010030 */
    private String appPageCat;

    /** 0-免费 1-付费 f6010040 */
    private Integer appPaid;

    /** 设备位置信息-国家 f6010050 */
    private String geoCountry;

    /** 设备位置信息-地区 f6010060 */
    private String geoRegion;

    /** 设备位置信息-城市 f6010070 */
    private String geoCity;

    /** 设备位置信息-定位类型 f6010080 */
    private Integer geoType;

    /** 预发券对象 */
    private List<AdxLoadAdvert> adxLoadAdvertList;

    /** 计费类型：1、一价计费；2、二价计费 */
    private Integer feeType;

    /** 请求ID，由ADX生成并传递，用于定位问题 */
    private String requestId;

    /** 曝光次数关系 */
    private String expTimeMap;

    /** 规格位编码，多个用逗号分隔 */
    private String specCode;

    /** 样式规格 */
    private Integer styleStandard;

    /** 竞价广告位顺序索引 */
    private Integer tagIndex;

    /** 设备号 当天竞价次数 */
    private Map<String, Long> imeiDayBidTimes;
    /** 设备号 当天曝光次数 */
    private Map<String, Long>  imeiDayExpTimes;
    /** 资源位id+设备号 当天竞价次数 */
    private Map<String, Long>  resoDayBidTimes;
    /** 资源位id+设备号 当天曝光次数 */
    private Map<String, Long>  resoDayExpTimes;

    /**模型融合收益*/
    private Double mergeRpm;
    /**模型预估收益*/
    private Double pRpm;
    /**模型预估收益*/
    private Double sRpm;

    public Double getMergeRpm() {
        return mergeRpm;
    }

    public void setMergeRpm(Double mergeRpm) {
        this.mergeRpm = mergeRpm;
    }

    public Double getpRpm() {
        return pRpm;
    }

    public void setpRpm(Double pRpm) {
        this.pRpm = pRpm;
    }

    public Double getsRpm() {
        return sRpm;
    }

    public void setsRpm(Double sRpm) {
        this.sRpm = sRpm;
    }

    public String getSpecCode() {
        return specCode;
    }

    public void setSpecCode(String specCode) {
        this.specCode = specCode;
    }

    public Integer getStyleStandard() {
        return styleStandard;
    }

    public void setStyleStandard(Integer styleStandard) {
        this.styleStandard = styleStandard;
    }

    public Integer getTagIndex() {
        return tagIndex;
    }

    public void setTagIndex(Integer tagIndex) {
        this.tagIndex = tagIndex;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUa() {
        return ua;
    }

    public void setUa(String ua) {
        this.ua = ua;
    }

    public String getCat() {
        return cat;
    }

    public void setCat(String cat) {
        this.cat = cat;
    }

    public String getTuiaCat() {
        return tuiaCat;
    }

    public void setTuiaCat(String tuiaCat) {
        this.tuiaCat = tuiaCat;
    }

    public String getSectionCat() {
        return sectionCat;
    }

    public void setSectionCat(String sectionCat) {
        this.sectionCat = sectionCat;
    }

    public String getTuiaSectionCat() {
        return tuiaSectionCat;
    }

    public void setTuiaSectionCat(String tuiaSectionCat) {
        this.tuiaSectionCat = tuiaSectionCat;
    }

    public String getKeywords() {
        return keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public Integer getPosType() {
        return posType;
    }

    public void setPosType(Integer posType) {
        this.posType = posType;
    }

    public Integer getPosStyle() {
        return posStyle;
    }

    public void setPosStyle(Integer posStyle) {
        this.posStyle = posStyle;
    }

    public Integer getResourcePicH() {
        return resourcePicH;
    }

    public void setResourcePicH(Integer resourcePicH) {
        this.resourcePicH = resourcePicH;
    }

    public Integer getResourcePicW() {
        return resourcePicW;
    }

    public void setResourcePicW(Integer resourcePicW) {
        this.resourcePicW = resourcePicW;
    }

    public Long getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(Long areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getDeviceType() {
        return deviceType;
    }

    public void setDeviceType(Integer deviceType) {
        this.deviceType = deviceType;
    }

    public Integer getTuiaDeviceType() {
        return tuiaDeviceType;
    }

    public void setTuiaDeviceType(Integer tuiaDeviceType) {
        this.tuiaDeviceType = tuiaDeviceType;
    }

    public String getMake() {
        return make;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public String getModel() {
        return model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getCarrier() {
        return carrier;
    }

    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    public Integer getConnectionType() {
        return connectionType;
    }

    public void setConnectionType(Integer connectionType) {
        this.connectionType = connectionType;
    }

    public Integer getTuiaConnectionType() {
        return tuiaConnectionType;
    }

    public void setTuiaConnectionType(Integer tuiaConnectionType) {
        this.tuiaConnectionType = tuiaConnectionType;
    }

    public Float getLat() {
        return lat;
    }

    public void setLat(Float lat) {
        this.lat = lat;
    }

    public Float getLon() {
        return lon;
    }

    public void setLon(Float lon) {
        this.lon = lon;
    }

    public Long getCurrentCreatTime() {
        return currentCreatTime;
    }

    public void setCurrentCreatTime(Long currentCreatTime) {
        this.currentCreatTime = currentCreatTime;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getAdxRid() {
        return adxRid;
    }

    public void setAdxRid(String adxRid) {
        this.adxRid = adxRid;
    }

    public String getOs() {
        return os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public Double getBasePrice() {
        return basePrice;
    }

    public void setBasePrice(Double basePrice) {
        this.basePrice = basePrice;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getInterestKeyWords() {
        return interestKeyWords;
    }

    public void setInterestKeyWords(String interestKeyWords) {
        this.interestKeyWords = interestKeyWords;
    }

    public String getYob() {
        return yob;
    }

    public void setYob(String yob) {
        this.yob = yob;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppBundle() {
        return appBundle;
    }

    public void setAppBundle(String appBundle) {
        this.appBundle = appBundle;
    }

    public String getAppPageCat() {
        return appPageCat;
    }

    public void setAppPageCat(String appPageCat) {
        this.appPageCat = appPageCat;
    }

    public Integer getAppPaid() {
        return appPaid;
    }

    public void setAppPaid(Integer appPaid) {
        this.appPaid = appPaid;
    }

    public String getGeoCountry() {
        return geoCountry;
    }

    public void setGeoCountry(String geoCountry) {
        this.geoCountry = geoCountry;
    }

    public String getGeoRegion() {
        return geoRegion;
    }

    public void setGeoRegion(String geoRegion) {
        this.geoRegion = geoRegion;
    }

    public String getGeoCity() {
        return geoCity;
    }

    public void setGeoCity(String geoCity) {
        this.geoCity = geoCity;
    }

    public Integer getGeoType() {
        return geoType;
    }

    public void setGeoType(Integer geoType) {
        this.geoType = geoType;
    }

    public List<AdxLoadAdvert> getAdxLoadAdvertList() {
        return adxLoadAdvertList;
    }

    public void setAdxLoadAdvertList(List<AdxLoadAdvert> adxLoadAdvertList) {
        this.adxLoadAdvertList = adxLoadAdvertList;
    }

    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType) {
        this.feeType = feeType;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getExpTimeMap() {
        return expTimeMap;
    }

    public void setExpTimeMap(String expTimeMap) {
        this.expTimeMap = expTimeMap;
    }

    public Map<String, Long> getImeiDayBidTimes() {
        return imeiDayBidTimes;
    }

    public void setImeiDayBidTimes(Map<String, Long> imeiDayBidTimes) {
        this.imeiDayBidTimes = imeiDayBidTimes;
    }

    public Map<String, Long> getImeiDayExpTimes() {
        return imeiDayExpTimes;
    }

    public void setImeiDayExpTimes(Map<String, Long> imeiDayExpTimes) {
        this.imeiDayExpTimes = imeiDayExpTimes;
    }

    public Map<String, Long> getResoDayBidTimes() {
        return resoDayBidTimes;
    }

    public void setResoDayBidTimes(Map<String, Long> resoDayBidTimes) {
        this.resoDayBidTimes = resoDayBidTimes;
    }

    public Map<String, Long> getResoDayExpTimes() {
        return resoDayExpTimes;
    }

    public void setResoDayExpTimes(Map<String, Long> resoDayExpTimes) {
        this.resoDayExpTimes = resoDayExpTimes;
    }
}