package cn.com.duiba.tuia.commercial.center.api.constant;

/**
 * 浮标样式类型枚举
 *
 * @author zhangbaiqiang
 * @date 2018/6/25
 */
public enum BuoyType {

    FIXED_BUOY(1, "浮标"),
    PULL_BUOY(2, "下拉"),
    ;

    private Integer type;
    private String desc;

    BuoyType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        if (null == type) {
            return "";
        }

        for (BuoyType buoyType : BuoyType.values()) {
            if (buoyType.getType().equals(type)) {
                return buoyType.getDesc();
            }
        }
        return "";
    }
}
