package cn.com.duiba.tuia.commercial.center.api.constant;

/**
 * 直投页区块类型
 * Created by YOUHAIJUN on 2017/7/10.
 */
public enum DirectBlockType {

    ADVERT_BLOCK(1,"广告区块"),
    FREEDOM_BLOCK(2,"自由配置区块"),
    ACTIVITY_BLOCK(3,"活动区块"),
    ADVERT_BLOCK2(4,"三期广告区块"),
    ACTIVITY_BLOCK2(5,"三期活动区块"),
    MAINMEET_BLOCK(6,"主会场区块"),
    PLUGIN_BLOCK(7,"插件区块-嵌入式"),
    GAME_BLOCK(8,"游戏区块");

    private Integer type;
    private String  desc;

    DirectBlockType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 判断是否直投页区块类型
     * @param blockType
     * @return
     */
    public static Boolean isDirectBlock(Integer blockType) {
        if(DirectBlockType.MAINMEET_BLOCK.getType().equals(blockType)
                || DirectBlockType.ACTIVITY_BLOCK2.getType().equals(blockType)
                || DirectBlockType.ADVERT_BLOCK2.getType().equals(blockType)
                || DirectBlockType.PLUGIN_BLOCK.getType().equals(blockType)) {
            return true;
        }
        return false;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
