package cn.com.duiba.tuia.commercial.center.api.constant;

import cn.com.duiba.tuia.commercial.center.api.constant.commercial.plant.PlantConstant;
import org.apache.commons.lang3.RandomUtils;

/**
 * [种红包]奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2018/11/12
 */
public enum PlantPrizeType {

    COUPON(1, "券"),
    CASH(2, "现金"),
    LAND(3, "解锁土地"),
    SEED(4, "解锁种子"),
    BLOCK(5, "区块"),
    ENCOURAGE(6, "激励广告"),
    FIRST_PRIZE(7, "新手奖励"),
    KETTLE(8, "水壶道具"),
    LOTTERY_TIMES(9, "抽奖次数"),
    EMPTY(10, "空"),
    ;

    private Integer type;
    private String desc;

    PlantPrizeType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算中奖类型
     *
     * @param couponProb 券概率(如果是70%，则传入70),目前默认是 券概率70%，cash=30%
     * @return 中奖类型
     */
    public static PlantPrizeType randomType(int couponProb) {
        return RandomUtils.nextInt(1, 101) <= couponProb ? PlantPrizeType.COUPON : PlantPrizeType.CASH;
    }

    public static PlantPrizeType randomType(int couponProb, int stageSignDays) {
        if (stageSignDays < 4)
            return RandomUtils.nextInt(1, 101) <= couponProb ? PlantPrizeType.COUPON : PlantPrizeType.CASH;
        else if (stageSignDays < 5) {// 累积登录第4天起，收红包有B=10%的概率获得大转盘的抽奖次数，单次获得的抽奖次数为1次
            int randomInt = RandomUtils.nextInt(1, 101);
            if (randomInt < couponProb - PlantConstant.PRIZE_LOTTERY)
                return PlantPrizeType.COUPON;
            else if (randomInt < couponProb)
                return PlantPrizeType.LOTTERY_TIMES;
            else
                return PlantPrizeType.CASH;
        } else { // 累积登录的第5天起，收红包有C=30%的概率抽空
            int randomInt = RandomUtils.nextInt(1, 101);
            if (randomInt < couponProb - PlantConstant.PRIZE_LOTTERY - PlantConstant.PRIZE_EMPTY)
                return PlantPrizeType.COUPON;
            else if (randomInt < couponProb - PlantConstant.PRIZE_EMPTY)
                return PlantPrizeType.LOTTERY_TIMES;
            else if (randomInt < couponProb)
                return PlantPrizeType.EMPTY;
            else
                return PlantPrizeType.CASH;
        }
    }
}
