package cn.com.duiba.tuia.commercial.center.api.constant.commercial.dig;

import org.apache.commons.lang3.RandomUtils;

import java.util.Objects;

public enum NodePrizeType {


    GODS_LIGHT(1,"神灯"),
    TREASURE_BOX(2,"宝箱"),
    CASH_RED_WALLET(3,"现金红包"),
    HIDDEN_TREASURE_CAVE(4,"藏宝洞"),
    GOLD_ORE(5,"金矿石"),
    ANCIENT_COIN(6,"古代钱币"),
    ANCIENT_SHOVEL(7,"上古铲子"),
    LOST_GRAIL(8,"遗失的圣杯"),
    EXTRATERRESTRIAL_INTELLIGENCE_STONE(9,"外星人石碑"),
    ANCIENT_PETRIFACTION(10,"远古化石"),
    ;


    private Integer code;

    private String desc;


    NodePrizeType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByCode(Integer code){
        for (NodePrizeType type:NodePrizeType.values()){
            if (Objects.equals(code,type.getCode())){
                return type.getDesc();
            }
        }
        return null;
    }


    /**
     * 按比例出 奖励
     * @param treasureBox  宝箱比例  如为60%   则传 60
     * @param godsLight  神灯比例  规则同上
     * @return
     */
    public static NodePrizeType getRandomPrize(Integer treasureBox, Integer godsLight) {
        int random = RandomUtils.nextInt(1, 101);
        return random <= treasureBox ? TREASURE_BOX : random <= treasureBox + godsLight ? GODS_LIGHT : CASH_RED_WALLET;
    }


    public static NodePrizeType getEnumByCode(Integer type){
        for (NodePrizeType nodePrizeType : NodePrizeType.values()){
            if (Objects.equals(type,nodePrizeType.getCode())){
                return nodePrizeType;
            }
        }
        return null;
    }

    /**
     * 现金百分比
     */
    public static Integer getCashPercent(Integer code) {
        if (code ==null){
            return null;
        }
        int random = RandomUtils.nextInt(1,101);
        NodePrizeType nodePrizeType = getEnumByCode(code);
        switch (nodePrizeType) {
            case GODS_LIGHT:
                return 50;
            case TREASURE_BOX:
                return 30;
            case CASH_RED_WALLET:
            case HIDDEN_TREASURE_CAVE:
                return 100;
            default:
                break;
        }
        return null;
    }


    /**
     * 出券出奖励比例
     */
    public static Integer getRandomCash(Integer code) {
        int random = RandomUtils.nextInt(1,101);
        NodePrizeType nodePrizeType = getEnumByCode(code);
        switch (nodePrizeType) {
            case GODS_LIGHT:
                return random <= 50 ? TreasurePrizeType.CASH.getCode() : TreasurePrizeType.TICKET.getCode();
            case TREASURE_BOX:
                return random <= 30 ? TreasurePrizeType.CASH.getCode() : TreasurePrizeType.TICKET.getCode();
            case CASH_RED_WALLET:
            case HIDDEN_TREASURE_CAVE:
                return TreasurePrizeType.CASH.getCode();
            default:
                break;
        }
        return TreasurePrizeType.TICKET.getCode();
    }


    /**
     *
     *  GOLD_ORE(5,"金矿石"),
     ANCIENT_COIN(6,"古代钱币"),
     ANCIENT_SHOVEL(7,"上古铲子"),
     LOST_GRAIL(8,"遗失的圣杯"),
     EXTRATERRESTRIAL_INTELLIGENCE_STONE(9,"外星人石碑"),
     ANCIENT_PETRIFACTION(10,"远古化石"),
     * 判断类型是否为图鉴
     * @param
     * @return
     */
    public static boolean isIllustrateHandbook(Integer code){
        NodePrizeType nodePrizeType = getEnumByCode(code);
        switch (nodePrizeType) {
            case GOLD_ORE:
            case ANCIENT_COIN:
            case ANCIENT_SHOVEL:
            case LOST_GRAIL:
            case EXTRATERRESTRIAL_INTELLIGENCE_STONE:
            case ANCIENT_PETRIFACTION:
                return true;
            default:
                break;
        }
        return false;
    }
}
