package cn.com.duiba.tuia.commercial.center.api.constant.commercial.plant;

import org.apache.commons.lang3.RandomUtils;

/**
 * [商业化活动]种红包奖励枚举
 *
 * @author zhangbaiqiang
 * @date 2019/03/14
 */
public enum PrizeType {

    COUPON(1, "券"),
    CASH(2, "现金"),
    LAND(3, "解锁土地"),
    SEED(4, "解锁种子"),
    BLOCK(5, "区块"),
    ENCOURAGE(6, "激励广告"),
    FIRST_PRIZE(7, "新手奖励"),
    VAT_RED_RAIN(13,  "红包雨"),
    VAT_TREASURE_CHEST(14, "增值任务宝箱"),
    ;

    private Integer type;
    private String  desc;

    PrizeType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 计算中奖类型
     *
     * @param couponProb 券概率(如果是70%，则传入70)
     * @return 中奖类型
     */
    public static PrizeType randomType(int couponProb) {
        return RandomUtils.nextInt(1, 101) <= couponProb ? PrizeType.COUPON : PrizeType.CASH;
    }
}
