package cn.com.duiba.tuia.commercial.center.api.dto;

import java.io.Serializable;
import java.util.List;

public class DistributionDto extends RuleConfigDto implements Serializable {

    private static final long serialVersionUID = 3646080339339313632L;

    /**
     * 难度配置
     */
    private List<DifficultyConfig> difficultyConfigList;

    /**
     * 道具规则 0 概率出现 1 固定关卡
     */
    private Integer propsRule;

    /**
     * 当为概率出现时，此字段生效，目前默认为100
     */
    private Integer propProbability;

    /**
     * 当为概率出现时，此字段生效，目前默认为1
     */
    private Integer propLimit;

    /**
     * 当为固定关卡时次字段生效,关卡Id集合
     */
    private String checkpointId;

    /**
     * 是否启用福袋 0关闭 1开启
     */
    private int luckyBag;

    public List<DifficultyConfig> getDifficultyConfigList() {
        return difficultyConfigList;
    }

    public void setDifficultyConfigList(List<DifficultyConfig> difficultyConfigList) {
        this.difficultyConfigList = difficultyConfigList;
    }

    public Integer getPropsRule() {
        return propsRule;
    }

    public void setPropsRule(Integer propsRule) {
        this.propsRule = propsRule;
    }

    public Integer getPropProbability() {
        return propProbability;
    }

    public void setPropProbability(Integer propProbability) {
        this.propProbability = propProbability;
    }

    public Integer getPropLimit() {
        return propLimit;
    }

    public void setPropLimit(Integer propLimit) {
        this.propLimit = propLimit;
    }

    public String getCheckpointId() {
        return checkpointId;
    }

    public void setCheckpointId(String checkpointId) {
        this.checkpointId = checkpointId;
    }

    public int getLuckyBag() {
        return luckyBag;
    }

    public void setLuckyBag(int luckyBag) {
        this.luckyBag = luckyBag;
    }

    public static class DifficultyConfig implements Serializable {

        private static final long serialVersionUID = 4726662262765482250L;

        /**
         * 红色区域占比
         */
        private Integer redArea;
        /**
         * 橙色区域占比
         */
        private Integer orangeArea;
        /**
         * 绿色区域占比
         */
        private Integer greenArea;

        /**
         * 是否移动
         */
        private boolean isMove;

        /**
         * 移动速度
         */
        private Integer moveSpeed;

        public Integer getRedArea() {
            return redArea;
        }

        public void setRedArea(Integer redArea) {
            this.redArea = redArea;
        }

        public Integer getOrangeArea() {
            return orangeArea;
        }

        public void setOrangeArea(Integer orangeArea) {
            this.orangeArea = orangeArea;
        }

        public Integer getGreenArea() {
            return greenArea;
        }

        public void setGreenArea(Integer greenArea) {
            this.greenArea = greenArea;
        }

        public boolean getIsMove() {
            return isMove;
        }

        public void setIsMove(boolean isMove) {
            this.isMove = isMove;
        }

        public Integer getMoveSpeed() {
            return moveSpeed;
        }

        public void setMoveSpeed(Integer moveSpeed) {
            this.moveSpeed = moveSpeed;
        }
    }
}
