package cn.com.duiba.tuia.commercial.center.api.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FishingConfigDto extends RuleConfigDto implements Serializable {
    private static final long serialVersionUID = -7394605823491529681L;

    // 炮筒额度
    private List<Integer> attackValue;

    //炮筒额度配置项（用于记录修改后的所有炮筒额度选项）
    private List<Integer> attackValueItems;

    // 怪物配置
    private List<FishingGamePrizesConfig> fishingGamePrizesConfigs;

    //怪物Url
    private List<ConfigUrl> pics;

    private List<GameTask> tasks;

    public FishingConfigDto() {
        if (this.tasks == null || this.tasks.isEmpty()) {
            this.tasks = new ArrayList<>();
            this.tasks.add(new GameTask(FishGameTaskKey.lev2.name(), "", 30, 1000L));
            this.tasks.add(new GameTask(FishGameTaskKey.lev3.name(), "", 15, 2000L));
            this.tasks.add(new GameTask(FishGameTaskKey.lev6.name(), "", 8, 5000L));
            this.tasks.add(new GameTask(FishGameTaskKey.boss.name(), "", 5, null));
            this.tasks.add(new GameTask(FishGameTaskKey.play.name(), "", 3, 1000L));
        }
    }

    public List<Integer> getAttackValueItems() {
        return attackValueItems;
    }

    public void setAttackValueItems(List<Integer> attackValueItems) {
        this.attackValueItems = attackValueItems;
    }

    public List<GameTask> getTasks() {
        return tasks;
    }

    public void setTasks(List<GameTask> tasks) {
        this.tasks = tasks;
    }

    public List<Integer> getAttackValue() {
        return attackValue;
    }

    public void setAttackValue(List<Integer> attackValue) {
        this.attackValue = attackValue;
    }

    public List<FishingGamePrizesConfig> getFishingGamePrizesConfigs() {
        return fishingGamePrizesConfigs;
    }

    public void setFishingGamePrizesConfigs(List<FishingGamePrizesConfig> fishingGamePrizesConfigs) {
        this.fishingGamePrizesConfigs = fishingGamePrizesConfigs;
    }

    public List<ConfigUrl> getPics() {
        return pics;
    }

    public void setPics(List<ConfigUrl> pics) {
        this.pics = pics;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    /**
     * 捕鱼游戏任务key
     */
    public enum FishGameTaskKey {
        lev2,
        lev3,
        lev6,
        boss,
        play
    }


    /**
     * 捕鱼游戏任务
     */
    public static class GameTask implements Serializable {
        private static final long serialVersionUID = 8341403384986989928L;

        //任务标识
        private String taskKey;

        //任务目标
        private String taskTarget;

        //任务达成条件
        private Integer taskCondition;

        //游戏奖励金额
        private Long rewardAmount;

        public GameTask() {
        }

        public GameTask(String taskKey, String taskTarget, Integer taskCondition, Long rewardAmount) {
            this.taskKey = taskKey;
            this.taskTarget = taskTarget;
            this.taskCondition = taskCondition;
            this.rewardAmount = rewardAmount;
        }

        public Long getRewardAmount() {
            return rewardAmount;
        }

        public void setRewardAmount(Long rewardAmount) {
            this.rewardAmount = rewardAmount;
        }

        public String getTaskKey() {
            return taskKey;
        }

        public void setTaskKey(String taskKey) {
            this.taskKey = taskKey;
        }

        public String getTaskTarget() {
            return taskTarget;
        }

        public void setTaskTarget(String taskTarget) {
            this.taskTarget = taskTarget;
        }

        public Integer getTaskCondition() {
            return taskCondition;
        }

        public void setTaskCondition(Integer taskCondition) {
            this.taskCondition = taskCondition;
        }
    }

}
