package cn.com.duiba.tuia.commercial.center.api.dto;

import java.io.Serializable;
import java.util.Date;

public class FundChangeDto implements Serializable {
    private static final long serialVersionUID = 1864930783412297786L;

    public static int AMOUNT_INIT = 0;
    public static int AMOUNT_ADD = 1;
    public static int AMOUNT_SUBTRACT = 2;
    public static int DUIBA_EXCHANGE = 3;

    private Long id;

    /**
     * 资金主体（游戏厅、游戏等）
     */
    private Long fundBodyId;
    /**
     * 资金主体类型（0：游戏厅；1：游戏）
     */
    private Integer fundBodyType;
    /**
     * 资金变动金额（单位：分）
     */
    private Long changeAmount;
    /**
     * 资金变动类型（0：资金预设；1：增加预算；2：减少预算；3：兑吧积分商城兑换）
     */
    private Integer changeType;
    /**
     * 资金变动备注（当为兑吧兑换时，填写兑换单号）
     */
    private String changeMsg;
    private Long outAmount;
    private Long totalAmount;
    private Date gmtCreate;

    private Date gmtModified;
    private String operator;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getFundBodyId() {
        return fundBodyId;
    }

    public void setFundBodyId(Long fundBodyId) {
        this.fundBodyId = fundBodyId;
    }

    public Integer getFundBodyType() {
        return fundBodyType;
    }

    public void setFundBodyType(Integer fundBodyType) {
        this.fundBodyType = fundBodyType;
    }

    public Long getChangeAmount() {
        return changeAmount;
    }

    public void setChangeAmount(Long changeAmount) {
        this.changeAmount = changeAmount;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public String getChangeMsg() {
        return changeMsg;
    }

    public void setChangeMsg(String changeMsg) {
        this.changeMsg = changeMsg;
    }

    public Long getOutAmount() {
        return outAmount;
    }

    public void setOutAmount(Long outAmount) {
        this.outAmount = outAmount;
    }

    public Long getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}
