package cn.com.duiba.tuia.commercial.center.api.dto;

import cn.com.duiba.tuia.commercial.center.api.common.BaseDto;

import java.util.Date;


/**
 * ClassName: ShieldRuleDto <br/>
 * Function: 屏蔽规则实体类. <br/>
 * date: 2017年3月14日 上午10:33:07 <br/>
 *
 * @author cdm
 * @version
 * @since JDK 1.7
 */
public class ShieldRuleDto extends BaseDto {


    private static final long serialVersionUID = 67705997609819514L;
    /**
     * 主键ID
     */
    private Long              id;

    /**
     * 规则类型；1:IP；2:user_agent
     */
    private Integer           ruleType;

    /**
     * 规则名称
     */
    private String            ruleName;

    /**
     * 规则内容
     */
    private String           ruleContent;

    /**
     * 规则匹配：0:模糊；1:精确
     */
    private Integer           ruleCondition;

    /**
     * 规则关联关系：0:或||；1:且&
     */
    private Integer            ruleRelation;

    /**
     * 规则关联ID，以逗号隔开。
     */
    private String           ruleRelationId;

    /**
     * 是否开启规则匹配：0:开启；1:关闭
     */
    private Integer            isOpen;

    /**
     * 规则制定者
     */
    private String            ruleFramer;

    /**
     * 创建时间
     */
    private Date              gmtCreate;

    /**
     * 更新时间
     */
    private Date              gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleContent() {
        return ruleContent;
    }

    public void setRuleContent(String ruleContent) {
        this.ruleContent = ruleContent;
    }

    public Integer getRuleCondition() {
        return ruleCondition;
    }

    public void setRuleCondition(Integer ruleCondition) {
        this.ruleCondition = ruleCondition;
    }

    public Integer getRuleRelation() {
        return ruleRelation;
    }

    public void setRuleRelation(Integer ruleRelation) {
        this.ruleRelation = ruleRelation;
    }

    public String getRuleRelationId() {
        return ruleRelationId;
    }

    public void setRuleRelationId(String ruleRelationId) {
        this.ruleRelationId = ruleRelationId;
    }

    public Integer getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Integer isOpen) {
        this.isOpen = isOpen;
    }

    public String getRuleFramer() {
        return ruleFramer;
    }

    public void setRuleFramer(String ruleFramer) {
        this.ruleFramer = ruleFramer;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
