package cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.config;

import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.CoefficientDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel
public class FinanceStageDto implements Serializable {

    private static final long serialVersionUID = 896974156460978909L;

    private Long id;

    private Long appId;

    // 阶段(从1开始，第几周期
    private Integer stage;

    // 周期天数
    private Integer period;

    @ApiModelProperty("预算单位(整数)")
    private Integer unitType;

    @ApiModelProperty("虚拟货币名称")
    private String unitName;

    @ApiModelProperty("奖励小数位数")
    private Integer digits;

    // 预算，单位分
    private Long budget;

    // 新增预算，单位分
    private Long addBudget;

    /*总预算*/
    private Long totalBudget;

    // 提现门槛单位分
    private Long withdrawThreshold;

    private List<CoefficientDto> coefficients;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getStage() {
        return stage;
    }

    public void setStage(Integer stage) {
        this.stage = stage;
    }

    public Integer getPeriod() {
        return period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public Integer getUnitType() {
        return unitType;
    }

    public void setUnitType(Integer unitType) {
        this.unitType = unitType;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Integer getDigits() {
        return digits;
    }

    public void setDigits(Integer digits) {
        this.digits = digits;
    }

    public Long getBudget() {
        return budget;
    }

    public void setBudget(Long budget) {
        this.budget = budget;
    }

    public Long getWithdrawThreshold() {
        return withdrawThreshold;
    }

    public void setWithdrawThreshold(Long withdrawThreshold) {
        this.withdrawThreshold = withdrawThreshold;
    }

    public Long getTotalBudget() {
        return totalBudget;
    }

    public void setTotalBudget(Long totalBudget) {
        this.totalBudget = totalBudget;
    }

    public List<CoefficientDto> getCoefficients() {
        return coefficients;
    }

    public void setCoefficients(List<CoefficientDto> coefficients) {
        this.coefficients = coefficients;
    }

    public Long getAddBudget() {
        return addBudget;
    }

    public void setAddBudget(Long addBudget) {
        this.addBudget = addBudget;
    }
}
