package cn.com.duiba.tuia.commercial.center.api.dto.inter;

import cn.com.duiba.tuia.commercial.center.api.constant.HttpMethod;
import cn.com.duiba.tuia.commercial.center.api.constant.ParseType;
import cn.com.duiba.tuia.commercial.center.api.constant.ProtocolType;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * ClassName: InterfaceHttpDto <br/>
 * Function: Http服务配置信息. <br/>
 * Reason: . <br/>
 * date: 2017年4月14日 下午5:38:58 <br/>
 *
 * @author wubo
 * @version
 * @since JDK 1.7
 */
public class InterfaceHttpDto extends InterfaceDto {

    private static final long                  serialVersionUID = 1L;

    /** url:请求url. */
    private String                             url;

    /** methodType:http方法. */
    private HttpMethod                         methodType;

    /** requestType:请求报文格式类型. */
    private ParseType                          requestType;

    /** responseType:返回报文格式类型. */
    private ParseType                          responseType;

    private Boolean                            isTranslate;

    private List<InterfaceHttpRequestDto>      request;

    private List<InterfaceHttpResponseDto>     response;

    private List<InterfaceHttpEncryptDto>      encrypt;

    private Map<Long, InterfaceHttpRequestDto> requestMap;

    /**
     * Creates a new instance of InterfaceHttpDto.
     */

    public InterfaceHttpDto() {
        super();
    }

    /**
     * Creates a new instance of InterfaceHttpDto.
     *
     * @param id
     * @param name
     * @param interfaceCode
     * @param protocolType
     * @param description
     * @param isStart
     * @param isDeleted
     * @param isLog
     */

    public InterfaceHttpDto(Long id, String name, String interfaceCode, ProtocolType protocolType, String description,
                            Boolean isStart, Boolean isDeleted, Boolean isLog) {
        super(id, name, interfaceCode, protocolType, description, isStart, isDeleted, isLog);
    }

    /**
     * Creates a new instance of InterfaceHttpDto.
     *
     * @param url
     * @param methodType
     * @param requestType
     * @param responseType
     * @param isTranslate
     * @param request
     * @param response
     * @param encrypt
     */

    public InterfaceHttpDto(String url, HttpMethod methodType, ParseType requestType, ParseType responseType,
                            Boolean isTranslate, List<InterfaceHttpRequestDto> request,
                            List<InterfaceHttpResponseDto> response, List<InterfaceHttpEncryptDto> encrypt) {
        super();
        this.url = url;
        this.methodType = methodType;
        this.requestType = requestType;
        this.responseType = responseType;
        this.isTranslate = isTranslate;
        this.request = request;
        this.response = response;
        this.encrypt = encrypt;
    }

    /**
     * Creates a new instance of InterfaceHttpDto.
     *
     * @param name
     * @param interfaceCode
     * @param protocolType
     * @param description
     * @param isLog
     * @param url
     * @param methodType
     * @param requestType
     * @param responseType
     * @param isTranslate
     */
    public InterfaceHttpDto(String name, String interfaceCode, ProtocolType protocolType, String description,
                            Boolean isLog, String url, HttpMethod methodType, ParseType requestType,
                            ParseType responseType, Boolean isTranslate) {
        super(null, name, interfaceCode, protocolType, description, true, false, isLog);
        this.url = url;
        this.methodType = methodType;
        this.requestType = requestType;
        this.responseType = responseType;
        this.isTranslate = isTranslate;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public HttpMethod getMethodType() {
        return methodType;
    }

    public void setMethodType(HttpMethod methodType) {
        this.methodType = methodType;
    }

    public ParseType getRequestType() {
        return requestType;
    }

    public void setRequestType(ParseType requestType) {
        this.requestType = requestType;
    }

    public ParseType getResponseType() {
        return responseType;
    }

    public void setResponseType(ParseType responseType) {
        this.responseType = responseType;
    }

    public Boolean getIsTranslate() {
        return isTranslate;
    }

    public void setIsTranslate(Boolean isTranslate) {
        this.isTranslate = isTranslate;
    }

    public List<InterfaceHttpRequestDto> getRequest() {
        return request;
    }

    public void setRequest(List<InterfaceHttpRequestDto> request) {
        this.request = request;
    }

    public List<InterfaceHttpResponseDto> getResponse() {
        return response;
    }

    public void setResponse(List<InterfaceHttpResponseDto> response) {
        this.response = response;
    }

    public List<InterfaceHttpEncryptDto> getEncrypt() {
        return encrypt;
    }

    public void setEncrypt(List<InterfaceHttpEncryptDto> encrypt) {
        this.encrypt = encrypt;
    }

    public InterfaceHttpRequestDto getRequestById(Long id) {
        if (id != null) {
            if (requestMap == null) {
                generateRequestMap();
            }
            return this.requestMap.get(id);
        }
        return null;
    }

    /*
     * TODO request 变更时，已有的map咋办?
     */
    private synchronized void generateRequestMap() {
        if (requestMap == null && request != null && !request.isEmpty()) {
            requestMap = new HashMap<>();
            for (InterfaceHttpRequestDto dto : request) {
                requestMap.put(dto.getId(), dto);
            }
        }
    }
}
