package cn.com.duiba.tuia.commercial.center.api.dto.plant.configV2.prize;

import cn.com.duiba.tuia.commercial.center.api.dto.plant.config.RuleConfig;

import java.io.Serializable;
import java.util.List;

/**
 * [种红包V2]奖励配置
 *
 * @author zhangbaiqiang
 * @date 2018/12/18
 */
public class PrizeConfig implements Serializable {
    private static final long serialVersionUID = 7415424444800176825L;

    /**
     * 生命周期中采摘次数下限
     */
    private Integer pickTimesMin;

    /**
     * 生命周期中采摘次数上限
     */
    private Integer pickTimesMax;

    /**
     * 出券概率
     */
    private Integer coupon;

    /**
     * 现金规则
     */
    private List<RuleConfig> cash;

    /**
     * 金币规则
     */
    private RuleConfig coin;

    /**
     * 是否必出现金
     */
    private Boolean mustCash;

    public Integer getPickTimesMin() {
        return pickTimesMin;
    }

    public void setPickTimesMin(Integer pickTimesMin) {
        this.pickTimesMin = pickTimesMin;
    }

    public Integer getPickTimesMax() {
        return pickTimesMax;
    }

    public void setPickTimesMax(Integer pickTimesMax) {
        this.pickTimesMax = pickTimesMax;
    }

    public Integer getCoupon() {
        return coupon;
    }

    public PrizeConfig setCoupon(Integer coupon) {
        this.coupon = coupon;
        return this;
    }

    public List<RuleConfig> getCash() {
        return cash;
    }

    public PrizeConfig setCash(List<RuleConfig> cash) {
        this.cash = cash;
        return this;
    }

    public RuleConfig getCoin() {
        return coin;
    }

    public PrizeConfig setCoin(RuleConfig coin) {
        this.coin = coin;
        return this;
    }

    public Boolean getMustCash() {
        return mustCash;
    }

    public void setMustCash(Boolean mustCash) {
        this.mustCash = mustCash;
    }
}
