/**
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.commercial.center.api.dto.req;

import java.util.List;

/**
 * 描述: 查询订单filter
 *
 * @version v1.0
 * @auther guopengfei@duiba.com.cn
 * @date 2018/4/3 18:27
 */
public class ActivityOrderReq extends ReqPageQuery {

    private Long consumerId;

    private List<IDReq> idReqList;

    private String startDate;

    private String endDate;

    /**
     * 是否谢谢参与 默认赋值true 兼容线上老虎机业务
     */
    private Boolean isParticipate=Boolean.TRUE;

    /**
     * 活动ID
     */
    private Long activityId;

    public ActivityOrderReq() {
    }

    public ActivityOrderReq(Long consumerId, Boolean isParticipate, Long activityId) {
        this.consumerId = consumerId;
        this.isParticipate = isParticipate;
        this.activityId = activityId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public List<IDReq> getIdReqList() {
        return idReqList;
    }

    public void setIdReqList(List<IDReq> idReqList) {
        this.idReqList = idReqList;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public Boolean getParticipate() {
        return isParticipate;
    }

    public void setParticipate(Boolean participate) {
        isParticipate = participate;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }
}
