/*
 * ReqPageQuery.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

/**
 * 
 */
package cn.com.duiba.tuia.commercial.center.api.dto.req;


import cn.com.duiba.tuia.commercial.center.api.common.BaseDto;

import java.util.Date;

/**
 * 此类描述的是： 分页查询条件.
 *
 * @author: leiliang
 * @version: 2016年2月18日 上午9:48:22
 */
public class ReqPageQuery extends BaseDto {


    /** 每页10条记录. */
    public static final int PAGE_SIZE_10    = 10;

    /** 每页20条记录. */
    public static final int PAGE_SIZE_20    = 20;

    /** 每页50条记录. */
    public static final int PAGE_SIZE_50    = 50;

    private static final long serialVersionUID = -9052866712359237685L;


    /** 起始记录数. */
    protected Integer         rowStart        = 0;

    /** 当前页. */
    protected Integer         currentPage     = 1;

    /** 每页记录数， 为-1时代表查询所有. */
    protected Integer         pageSize;

    protected Date start;

    protected Date end;


    public ReqPageQuery() {
        super();
    }

    public Date getStart() {
        return start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public Integer getRowStart() {
        return rowStart;
    }

    public void setRowStart(Integer rowStart) {
        this.rowStart = rowStart;
    }

    public Integer getCurrentPage() {
        return currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

}
