/*
 * RemoteCardCollectOrderService.java
 * Copyright 2019 Qunhe Tech, all rights reserved.
 * Qunhe PROPRIETARY/CONFIDENTIAL, any form of usage is subject to approval.
 */

package cn.com.duiba.tuia.commercial.center.api.remoteservice.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.card.ActivityPluginRelationDto;

/**
 * 描述：集卡订单服务
 *
 * @author weny.cai
 * @date 2018/10/12 15:29
 **/
@AdvancedFeignClient
public interface RemoteCardCollectOrderService {

    /**
     * 判断token是否有效
     *
     * @param activityId 活动id
     * @param consumerId 用户id
     * @param exchangeToken 待校验的token
     * @return true.有效；false.已失效
     */
    Boolean isTokenValid(Long activityId, Long consumerId, String exchangeToken);


}
