package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.plant;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.constant.commercial.plant.PlantConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.CommercialUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.LotteryDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PlantDto;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.plant.PropDto;

import java.util.List;

@AdvancedFeignClient
public interface RemotePlantV4Service {

    /**
     * 签到
     *
     * @param req 用户参数
     * @return 种红包所有信息
     * @throws BizException
     */
    PlantDto sign(CommercialUserReq req) throws BizException;

    /**
     * 种红包
     *
     * @param req      用户参数
     * @param landId   土地编号
     * @param seedType 种子类型
     * @return 用户信息、土地信息、种子仓库
     * @throws BizException
     */
    PlantDto plant(CommercialUserReq req, Integer landId, Integer seedType) throws BizException;

    /**
     * 采摘红包
     *
     * @param req    用户参数
     * @param seedId 种子编号
     * @return 用户信息，奖励信息
     * @throws BizException
     */
    PlantDto pick(CommercialUserReq req, Long seedId) throws BizException;

    /**
     * 领取任务奖励
     *
     * @param req       用户参数
     * @param missionId 任务编号
     * @return 用户信息，奖励信息
     */
    PlantDto finishMission(CommercialUserReq req, String missionId) throws BizException;

    /**
     * 获取种红包奖励配置
     *
     * @return 种红包奖励配置
     */
    PlantConfigDto queryPrizeConfig() throws BizException;

    /**
     * 更新奖励配置参数(慎用)
     *
     * @param configDto 奖励配置对象
     * @return 是否更新成功
     */
    boolean updatePlantConfig(PlantConfigDto configDto);

    /**
     * 用户使用道具，
     *
     * @param req
     * @param landId
     * @param propType
     * @return
     * @throws BizException
     */
    PropDto useProp(CommercialUserReq req, Integer landId, Integer propType) throws BizException;

    /**
     * @param req
     * @return
     * @throws BizException
     */
    LotteryDto lotteryEveryday(CommercialUserReq req) throws BizException;


    /**
     * @param req
     * @return
     * @throws BizException
     */
    int finishVat(CommercialUserReq req) throws BizException;

    /**
     * 换天接口
     * @param deviceId
     * @param appId
     * @param date
     * @return
     * @throws BizException
     */
    Boolean resetForTest(String deviceId, Long appId, String date) throws BizException;

    /**
     * 获取浮标显示天数
     * @param activityId
     * @return
     */
    List<Integer> getBouyShowDays(Long activityId);

    /**
     * 设置浮标天数
     * @param activityId
     * @param showDaysStr
     * @return
     */
    boolean setBouyShowDays(Long activityId, String showDaysStr);

}
