package cn.com.duiba.tuia.commercial.center.api.constant.farm;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 奖励类型  1-金币  2 红包  3 券
 * @author yuantong
 * @version 1.0
 * @since 2019-11-26 10:22
 */
public enum PrizeTypeEnum {

    COIN(1, "金币"),
    RED_PACKET(2, "红包"),
    TICKET(3, "券");

    @Getter
    private Integer prizeType;
    @Getter
    private String desc;

    PrizeTypeEnum(Integer prizeType, String desc) {
        this.prizeType = prizeType;
        this.desc = desc;
    }

    private static Map<Integer, PrizeTypeEnum> prizeTypeEnumMap;
    static {
        prizeTypeEnumMap = new HashMap<>(3);
        PrizeTypeEnum[] prizeEnums = PrizeTypeEnum.values();
        for (PrizeTypeEnum prizeEnum : prizeEnums) {
            prizeTypeEnumMap.put(prizeEnum.getPrizeType(), prizeEnum);
        }
    }

    public static PrizeTypeEnum getEnumByPrizeType(Integer prizeType) {
        return prizeTypeEnumMap.get(prizeType);
    }
}
