package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmFacilityDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmFacilityReq;

import java.util.List;

/**
 * [红包农场] 设施
 * Created by xuefeng on 2019/11/25.
 */
@AdvancedFeignClient
public interface RemoteFarmFacilityService {

    /**
     * 查询用户设施数据
     *
     * @param farmFacilityReq 设施信息
     * @return 用户设施信息
     */
    List<FarmFacilityDto> queryFarmFacilityInfos(FarmFacilityReq farmFacilityReq) throws BizException;

    /**
     * 升级用户设施
     *
     * @param farmFacilityReq 设施信息
     * @return 升级后的设施信息&用户信息
     */
    FarmDto upgradeFarmFacility(FarmFacilityReq farmFacilityReq) throws BizException;

    /**
     * 使用设施
     *
     * @param req 用户信息
     * @return 农场信息
     */
    FarmDto useFacility(FarmFacilityReq req) throws BizException;
}
