package cn.com.duiba.tuia.commercial.center.api.dto.commercial.mission;

import java.io.Serializable;

/**
 * [商业化活动]任务项
 *
 * @author zhangbaiqiang
 * @date 2019/03/07
 */
public class MissionItem implements Serializable {
    private static final long serialVersionUID = 7819914870704505369L;

    /**
     * 任务描述
     */
    private String desc;

    /**
     * 奖励描述
     */
    private String prizeDesc;

    /**
     * 图片链接
     */
    private String picUrl;

    /**
     * 循环类型
     */
    private String cycleType;

    /**
     * 起始任务展示(包含)
     */
    private Integer startShowDay;

    /**
     * 结束任务展示(包含)
     */
    private Integer endShowDay;

    /**
     * 在第几天预览，为空则是非预览任务
     */
    private Integer previewDay;

    /**
     * 作为前置条件的任务ID，完成后才能触发该任务
     */
    private String precondition;

    /**
     * 排序，数值越大越靠前
     */
    private Integer order;

    /**
     * 任务条件
     */
    private MissionCondition condition;

    /**
     * 任务奖励
     */
    private MissionPrize prize;

    /**
     * 任务对应的落地页连接（特定皮肤中会存在直接跳到落地页的任务）
     */
    private String landingPageUrl;

    /**
     * 任务对应的落地页弹层图片连接（特定皮肤中会存在直接跳到落地页的任务）
     */
    private String landingPageImgUrl;

    /**
     * 闯关任务当前的场景类型
     */
    private Integer preScene;

    /**
     * 闯关任务完成之后切换的场景类型
     */
    private Integer postScene;

    /**
     * 闯关任务场景解锁图片
     */
    private String sceneImgUrl;

    /**
     * 闯关任务标题
     */
    private String sceneTitle;

    /**
     * 显示状态 0、 在任务栏显示 1、在窗口和任务栏显示
     */
    private Integer showStatus;

    public Integer getShowStatus() {
        return showStatus;
    }

    public void setShowStatus(Integer showStatus) {
        this.showStatus = showStatus;
    }

    public String getLandingPageUrl() {
        return landingPageUrl;
    }

    public void setLandingPageUrl(String landingPageUrl) {
        this.landingPageUrl = landingPageUrl;
    }

    public String getLandingPageImgUrl() {
        return landingPageImgUrl;
    }

    public void setLandingPageImgUrl(String landingPageImgUrl) {
        this.landingPageImgUrl = landingPageImgUrl;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getPrizeDesc() {
        return prizeDesc;
    }

    public void setPrizeDesc(String prizeDesc) {
        this.prizeDesc = prizeDesc;
    }

    public String getPicUrl() {
        return picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public Integer getPreviewDay() {
        return previewDay;
    }

    public void setPreviewDay(Integer previewDay) {
        this.previewDay = previewDay;
    }

    public String getCycleType() {
        return cycleType;
    }

    public void setCycleType(String cycleType) {
        this.cycleType = cycleType;
    }

    public Integer getStartShowDay() {
        return startShowDay;
    }

    public void setStartShowDay(Integer startShowDay) {
        this.startShowDay = startShowDay;
    }

    public Integer getEndShowDay() {
        return endShowDay;
    }

    public void setEndShowDay(Integer endShowDay) {
        this.endShowDay = endShowDay;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getPrecondition() {
        return precondition;
    }

    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    public MissionCondition getCondition() {
        return condition;
    }

    public void setCondition(MissionCondition condition) {
        this.condition = condition;
    }

    public MissionPrize getPrize() {
        return prize;
    }

    public void setPrize(MissionPrize prize) {
        this.prize = prize;
    }

    public Integer getPreScene() {
        return preScene;
    }

    public void setPreScene(Integer preScene) {
        this.preScene = preScene;
    }

    public Integer getPostScene() {
        return postScene;
    }

    public void setPostScene(Integer postScene) {
        this.postScene = postScene;
    }

    public String getSceneImgUrl() {
        return sceneImgUrl;
    }

    public void setSceneImgUrl(String sceneImgUrl) {
        this.sceneImgUrl = sceneImgUrl;
    }

    public String getSceneTitle() {
        return sceneTitle;
    }

    public void setSceneTitle(String sceneTitle) {
        this.sceneTitle = sceneTitle;
    }
}
