package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;

/**
 * FarmFruitDto
 * 农场果实信息
 * @author huangruodan
 * @date 2019-11-21
 */
@Data
public class FarmFruitDto implements Serializable {
    private static final long serialVersionUID = -3470435048490180404L;

    /**
     * 种子id
     */
    private Long fruitId;

    /**
     * 种子类型
     */
    private Integer fruitType;

    /**
     * 种子等级
     */
    private Integer fruitLevel;

    /**
     * 成熟倒计时
     */
    private Integer matureCountdown;

    /**
     * 宝箱状态 1、显示 2、隐藏
     */
    private Integer boxStatus;

    /**
     * 图片地址
     */
    private String imageUrl;

    /**
     * 是否已解锁（同土地）
     */
    private boolean unlock;

    /**
     * 金币产出速率
     */
    private Integer cashSpeed;

    /**
     * 成长速率
     */
    private Integer growSpeed;

    /**
     * 果实升级配置
     */
    private FarmFruitConfigDto upgradeConfig;

    // TODO zbq 果实配置
}
