package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmFinanceRewardDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmFinanceDoubleReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmFinanceReceiveRewardReq;

/**
 * RemoteFarmFinanceService
 * 红包农场
 * @author huangruodan
 * @date 2019-12-02
 */

@AdvancedFeignClient
public interface RemoteFarmFinanceService {


    /**
     * 用户奖励
     * @param doubleReq 加倍订单参数
     * @return 增加的奖励
     * @throws BizException 参数异常
     */
    Long doubleReward(FarmFinanceDoubleReq doubleReq) throws BizException;

    /**
     * 领取奖励
     * @param receiveRewardReq 用户参数、业务类型
     * @return 用户奖励信息
     * @throws BizException 业务异常
     */
    FarmFinanceRewardDto receiveReward(FarmFinanceReceiveRewardReq receiveRewardReq) throws BizException;
}
