package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmReportActivityDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmHeartbeatReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmReportActivityReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.NewUseGuidanceReq;

/**
 * RemoteFarmService
 *
 * @author huangruodan
 * @date 2019-12-03
 */

@AdvancedFeignClient
public interface RemoteFarmService {


    FarmDto initialize(FarmUserReq farmUserReq) throws BizException;

    /**
     * 互动上报
     *
     * @param activityReq 用户信息、上报类型
     * @return 奖励数量（激励互动时会有金币奖励，其他场景暂时没有）
     * @throws BizException
     */
    FarmReportActivityDto reportActivity(FarmReportActivityReq activityReq) throws BizException;

    /**
     * 记录用户心跳时间
     * @param heartbeatReq 心跳时间
     * @return 是否成功
     * @throws BizException
     */
    Boolean heartbeat(FarmHeartbeatReq heartbeatReq) throws BizException;


    /**
     * 新手引导监听接口
     *
     * @param guidanceReq
     * @return
     * @throws BizException
     */
    Boolean clickListener(NewUseGuidanceReq guidanceReq) throws BizException;
}
