package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import lombok.Data;

import java.io.Serializable;

/**
 * FarmFinanceVersionConfigDto
 *
 * @author huangruodan
 * @date 2020-01-20
 */

@Data
public class FarmFinanceVersionConfigDto implements Serializable {

    private static final long serialVersionUID = -8211848927615492539L;

    private Long id;

    /**
     * 红包过期天数
     */
    private Integer redPacketExpireDays;

    /**
     * 提现门槛
     */
    private Integer withdrawThreshold;

    /**
     * 提现周期
     */
    private Integer period;

    /**
     * 常量C
     */
    private Double constantC;

    private Double constantA;

    private Double constantP;

    private Double constantPercent;

    private Integer dayFixedRedPacketNum;

    private Integer stage;

    /**
     * 宝箱红包掉落次数左区间
     */
    private Integer dayMinRedPacketTimes;

    /**
     * 宝箱红包掉落次数右区间
     */
    private Integer dayMaxRedPacketTimes;

    /**
     * 红包掉落概率
     */
    private Double redPacketRate;

    /**
     * 任务最小随机概率
     */
    private Double minTaskRate;

    /**
     * 任务最大随机概率
     */
    private Double maxTaskRate;

    /**
     * 每日最小任务数
     */
    private Integer dayMinTaskNum;

    /**
     * 每日最大任务数
     */
    private Integer dayMaxTaskNum;

    private Integer configVersion;

}
