package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.WithdrawRsp;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.WithdrawReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmWithdrawRecordDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmWithdrawService {

    /*
    预提现 接口判断当前是否有提现资格
    */
    Boolean preWithdraw(WithdrawReq req) throws BizException;

    /*
    提现接口，实现红包包农场数据修改逻辑
     */
    WithdrawRsp withdraw(WithdrawReq req) throws BizException;

    List<FarmWithdrawRecordDto> selectRecordByUserId(Long userId);

    int insertRecord(FarmWithdrawRecordDto withDrawRecord);

    int updateRecord(FarmWithdrawRecordDto withDrawRecord);

    String selectOrder(FarmUserReq req);

    List<FarmWithdrawRecordDto> selectRecordBy(FarmUserReq req);

}
