package cn.com.duiba.tuia.commercial.center.api.constant.farm;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 随机事件枚举类型 以后增加了枚举类型记得在这里添加
 * @author yuantong
 * @version 1.0
 * @since 2019-11-26 10:22
 */
public enum FarmEventEnum {

    TREASURE_BOX(1, "宝箱"),
    BEAT_MOSE(2, "打地鼠"),
    SECRET_VISITOR(3, "神秘访客"),
    DOUBLE_REWARD(4, "翻倍");

    @Getter
    private Integer eventType;
    @Getter
    private String desc;

    FarmEventEnum(Integer eventType, String desc) {
        this.eventType = eventType;
        this.desc = desc;
    }

    private static Map<Integer, FarmEventEnum> eventTypeEnumMap;
    static {
        eventTypeEnumMap = new HashMap<>(3);
        FarmEventEnum[] eventEnums = FarmEventEnum
                .values();
        for (FarmEventEnum eventEnum : eventEnums) {
            eventTypeEnumMap.put(eventEnum.getEventType(), eventEnum);
        }
    }

    public static FarmEventEnum getEnumByEventType(Integer eventType) {
        return eventTypeEnumMap.get(eventType);
    }

    public static String getDescByType(Integer eventType) {
        FarmEventEnum eventEnum = eventTypeEnumMap.get(eventType);
        if (eventEnum != null) {
            return eventEnum.getDesc();
        }
        return "";
    }

}
