package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmEventReq;

/**
 * 新手礼包
 * Created by xuefeng on 2020/2/10.
 */
@AdvancedFeignClient
public interface RemoteFarmBeginGiftService {

    /**
     * 新手礼包信息
     * @param userReq 用户基本信息
     * @return
     */
    FarmDto beginGift(FarmUserReq userReq) throws BizException;

    /**
     * 领取新手礼包
     * @param req 随机事件请求参数
     * @return
     */
    FarmDto fetchBeginGift(FarmEventReq req) throws BizException;

    /**
     * 新增或更新配置
     * @param gifyDay 天
     * @param coinNum 金币，为0不出
     * @param packetNum 红包，为0不出
     * @return
     */
    Boolean addOrUpdate(Integer gifyDay, Integer coinNum, Integer packetNum);
}
