package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;


import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.req.FinanceConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmActivityVersionConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmAppBudgetDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmFinanceConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance.FarmVersionConfigReq;

@AdvancedFeignClient
public interface RemoteFarmFinanceConfigService {

    int delete(Long id);

    int deleteByAppIdAndStage(FinanceConfigReq req) throws BizException;

    int insert(FarmFinanceConfigDto financeConfig) throws BizException;

    int update(FarmFinanceConfigDto financeConfig) throws BizException;

    int addBudget(FarmFinanceConfigDto financeConfig) throws BizException;

    FarmFinanceConfigDto getById(Long id) throws BizException;

    FarmFinanceConfigDto selectByAppIdAndStage(FinanceConfigReq req) throws BizException;


    /**
     * 保存版本配置
     * @param configReq 配置信息、版本
     * @return 是否成功
     */
    Boolean saveVersionConfig(FarmVersionConfigReq configReq) throws BizException ;

    /**
     * 保存活动版本配置
     * @param configDto
     * @return
     * @throws BizException
     */
    Boolean saveActivityConfigVersion(FarmActivityVersionConfigDto configDto) throws BizException;

    /**
     * 保存预算
     * @param appBudget 预算
     * @return 是否成功
     */
    Boolean saveFarmBudgetConfigDto(FarmAppBudgetDto appBudget) throws BizException;
}
