package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmFruitReq;

/**
 * 【红包农场】果实接口
 *
 * @author zhangbaiqiang
 * @date 2019/12/3
 */
@AdvancedFeignClient
public interface RemoteFarmFruitService {

    /**
     * 收取果实
     *
     * @param req 用户和果实信息
     * @return 农场信息
     */
    FarmDto pickFruit(FarmFruitReq req) throws BizException;

    /**
     * 升级果实
     *
     * @param req 用户和果实信息
     * @return 农场信息
     */
    FarmDto upgradeFruit(FarmFruitReq req) throws BizException;
}
