package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmConversionDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmPacketDetailDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;

import java.util.List;

@AdvancedFeignClient
public interface RemoteFarmRedPacketService {

    /**
     * 获取用户红包明细
     *
     * @param req
     * @return
     */
    List<FarmPacketDetailDto> getUserPacketDetail(FarmUserReq req) throws BizException;

    /**
     * 获取用户兑换列表
     *
     * @param req
     * @return
     * @throws BizException
     */
    FarmConversionDto getUserConversion(FarmUserReq req) throws BizException;
}
