package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 灌溉配置
 * FarmWaterConfigDto
 *
 * @author huangruodan
 * @date 2019-11-21
 */

@Data
public class FarmWaterConfigDto implements Serializable {

    private static final long serialVersionUID = -4780148868966004726L;

    private Long id;

    //等级
    private Integer waterLevel;

    //升级需要金币
    private Integer cashUpgrade;

    //奖励数量
    private Integer prizeAmount;

    //暴击奖励数量
    private Integer critAmount;

    //暴击率n，灌溉n次出现1此暴击
    private Integer critRate;

    //展示暴击率
    private Integer critPercent;

    //冷却功能配置
    private String cdConfig;

    private List<CdConfigDto> cdConfigDtos;

    private String imageUrl;

    private Date gmtCreate;

    private Date gmtModified;

    private Integer configVersion;

    private Double critPrizeCoefficient;

    private Double waterPrizeCoefficient;


    /**
     * 灌溉冷却规则从字符串转成dto
     */
    public List<CdConfigDto> getCdConfigDto() {
        if (StringUtils.isNotEmpty(cdConfig)) {
            return cdConfigDtos = JSON.parseArray(cdConfig, CdConfigDto.class);
        }
        return Collections.emptyList();
    }

    /**
     * 灌溉冷却规则
     */
    @Data
    public static class CdConfigDto implements Serializable {

        private static final long serialVersionUID = -4043851167555454737L;
        //cd内可灌溉次数
        private Integer waterTimes;

        //cd时长
        private Integer cdTime;
    }
}
