package cn.com.duiba.tuia.commercial.center.api.dto.travel;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @ClassName TravelUserCityDTO
 * @Description 城市信息
 * @Author zaizai
 * @Date 2021/8/17 2:16 下午
 */
public class TravelUserCityDTO implements Serializable {

    private static final long serialVersionUID = -8288107803410302264L;

    @ApiModelProperty("城市编码")
    private String cityCode;

    @ApiModelProperty("城市名称")
    private String cityName;

    @ApiModelProperty("开放时间戳 秒级")
    private Long openTimeStamp;

    @ApiModelProperty("解锁时间戳 秒级")
    private Long unlockTimeStamp;

    @ApiModelProperty("解锁状态 0 未解锁 1 已解锁")
    private Integer unlockState;

    @ApiModelProperty("开放状态 0 未开放 1 已开放")
    private Integer openState;

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Long getOpenTimeStamp() {
        return openTimeStamp;
    }

    public void setOpenTimeStamp(Long openTimeStamp) {
        this.openTimeStamp = openTimeStamp;
    }

    public Long getUnlockTimeStamp() {
        return unlockTimeStamp;
    }

    public void setUnlockTimeStamp(Long unlockTimeStamp) {
        this.unlockTimeStamp = unlockTimeStamp;
    }

    public Integer getUnlockState() {
        return unlockState;
    }

    public void setUnlockState(Integer unlockState) {
        this.unlockState = unlockState;
    }

    public Integer getOpenState() {
        return openState;
    }

    public void setOpenState(Integer openState) {
        this.openState = openState;
    }
}
