package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmResetSignInfoReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmForTestReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.req.FarmUserReq;

/**
 * 为测试在预发上写编写接口 预发之后就下架掉 不留后门
 * @author yuantong
 * @version 1.0
 * @since 2019-12-10 11:29
 */
@AdvancedFeignClient
public interface RemoteFarmForTestService {

    /**
     * 计算农场收益
     * @param req calType 土地收益类型 1、单次 2、每秒  、 userReq 用户信息
     * @return 农场收益
     * @throws BizException 未知错误
     */
    Long calculateFarmProfitPerSecond(FarmForTestReq req) throws BizException;

    /**
     * 换天
     * @param userReq 用户信息
     * @return 是否成功
     * @throws BizException 未知错误
     */
    Boolean resetForTest(FarmUserReq userReq) throws BizException;

    /**
     * 更新浇灌冷却时间
     * @param userReq 用户信息
     * @return 是否成功
     * @throws BizException 未知错误
     */
    Boolean updateWaterTime(FarmUserReq userReq) throws BizException;

    /**
     * 把果实升级时间更新到当前时间
     * @param fruitId 果实id
     * @return 是否成功
     * @throws BizException 未知错误
     */
    Boolean updateFruitRipeTime(Long fruitId) throws BizException;

    /**
     * 修改用户金币或者红包
     * @param req userReq 用户信息、redPacketNum 红包、cash 金币
     * @return 是否成功
     * @throws BizException 未知错误
     */
    Boolean updateBaseUserCoinOrRedPacket(FarmForTestReq req) throws BizException;


    /**
     * 重置签到信息  给测试用
     *
     * @return
     */
    Boolean resetSignInfo(FarmResetSignInfoReq resetSignInfoReq) throws BizException;

    /**
     * 重置设施完成时间
     */
    Boolean resetFacilityFinishTime(FarmForTestReq req) throws BizException;

    /**
     * 重置stageStartTime,测试红包
     * @param userReq
     * @return
     */
    Boolean updateStageStartTime(FarmUserReq userReq) throws BizException;


    /**
     * 手工触发每日预算的定时任务
     * @return
     * @throws BizException
     */
    Boolean buildDailyBudget() throws BizException;


}
