package cn.com.duiba.tuia.commercial.center.api.dto.farm.finance;

import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmRateConfigDto;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 【红包农场】翻倍弹窗配置
 *
 * @author zhangbaiqiang
 * @date 2019/12/9
 */
@Data
public class FarmDoubleConfigDto implements Serializable {
    private static final long serialVersionUID = -1279829810427841701L;

    /**
     * 媒体id
     */
    private Long appId;


    /**
     * 翻倍弹窗出现概率[0, 100]
     */
    private Integer rate;

    /**
     * 配置更新时间
     */
    private Date updateTime;


    /**
     * 在用户解锁X块土地之前，翻倍弹窗不出现；在土地解锁X块土地后，按照次数阶梯概率出现翻倍弹窗（次数从解锁后重新累积）
     */
    private Integer unlockLand;

    /**
     * 每日最大翻倍奖励获取次数
     */
    private Integer limitTimes;

    /**
     * 翻倍间隔次数
     */
    private Integer rewardGapTimes;

    /**
     * 概率配置列表
     */
    private List<FarmRateConfigDto> rateList;

}
