package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * [合成游戏]用户表
 */
@Getter
@Setter
public class SynUserDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "媒体ID")
    private Long appId;

    @ApiModelProperty(value = "用户ID")
    private Long baseUserId;

    @ApiModelProperty(value = "宠物最高等级")
    private Integer topGrade;

    @ApiModelProperty(value = "金币增长速度（每秒）")
    private Long growRate;

    @ApiModelProperty(value = "宠物收益")
    private String coin;

    @ApiModelProperty(value = "用户宠物")
    private List<UserPetDTO> userPets;

    @ApiModelProperty(value = "当前等级宠物购买次数")
    private Integer buyPetCount;

    @ApiModelProperty(value = "普通合成次数")
    private Integer normalSynCount;

    @ApiModelProperty(value = "是否新手用户")
    private Boolean isNew;

    @ApiModelProperty(value = "新手引导步骤")
    private Integer guideStep;

    @ApiModelProperty(value = "上次操作时间")
    private Date lastOperateTime;

    @ApiModelProperty(value = "额外的用户用户等级（好省定制）")
    private String extraUserType;

    @Getter
    @Setter
    @AllArgsConstructor
    public static class UserPetDTO implements Serializable {

        private static final long serialVersionUID = 1L;

        public static final UserPetDTO DEFAULT = new UserPetDTO(0L, 0, 0);

        @ApiModelProperty(value = "宠物ID")
        @JSONField(name = "id", serialize = false) // 暂未使用，节约空间不保存
        private Long petId;

        @ApiModelProperty(value = "宠物等级")
        @JSONField(name = "g")
        private Integer petGrade;

        @ApiModelProperty(value = "宠物位置")
        @JSONField(name = "p")
        private Integer petPosition;

        @Override
        public boolean equals(Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof UserPetDTO)) return false;
            UserPetDTO other = (UserPetDTO) obj;
            return petGrade.equals(other.getPetGrade());
        }

        @Override
        public int hashCode() {
            return petGrade.hashCode();
        }

        public static UserPetDTO newEmpty(Integer petPosition) {
            return new UserPetDTO(0L, 0, petPosition);
        }
    }

}