package cn.com.duiba.tuia.commercial.center.api.dto.travel.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 环游世界任务配置表
 */
@Getter
@Setter
@SuppressWarnings("serial")
public class TravelMissionConfigDTO implements Serializable {

    @ApiModelProperty(value = "任务编号")
    private String missionCode;

    @ApiModelProperty(value = "任务类型[0-用户历程任务 1用户主播历程任务 2用户主播日常任务]")
    private Integer missionType;

    @ApiModelProperty(value = "条件类型")
    private String conditionType;

    @ApiModelProperty(value = "完成条件")
    private String completeCondition;

    @ApiModelProperty(value = "任务奖励类型")
    private Integer awardType;

    @ApiModelProperty(value = "奖励描述")
    private String awardDesc;

    @ApiModelProperty(value = "任务奖励(数值)")
    private Long awardAmount;

    @ApiModelProperty(value = "任务描述")
    private String missionDesc;

    @ApiModelProperty(value = "任务条件(数值)")
    private Long conditionAmount;

    @ApiModelProperty(value = "0-不在任务列表展示 1-在任务列表显示 ")
    private Integer showStatus;

    @ApiModelProperty(value = "额外信息")
    private String extInfo;

    @ApiModelProperty(value = "图片")
    private String photoUrl;

    @ApiModelProperty(value = "任务顺序")
    private Integer missionSort;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

}