package cn.com.duiba.tuia.commercial.center.api.remoteservice.farm;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmContributionConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.FarmLevelFinanceConfigDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.finance.FarmDoubleConfigDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmContributionConfigReq;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.req.FarmLevelFinanceConfigReq;

import java.util.List;

/**
 * 【红包农场】媒体配置接口
 *
 * @author zhangbaiqiang
 * @date 2019/12/10
 */
@AdvancedFeignClient
public interface RemoteFarmAppConfigService {

    /**
     * 更新媒体的翻倍弹窗配置
     *
     * @param config 翻倍弹窗配置
     * @return 更新后的翻倍弹窗配置
     */
    FarmDoubleConfigDto updateAppDoubleConfig(FarmDoubleConfigDto config);

    /**
     * 更新媒体白名单
     *
     * @param type        白名单类型
     * @param appId       媒体id
     * @param operateType 操作类型
     * @return 更新后的白名单
     */
    List<Long> updateAndGetAppWhitelist(Integer type, Long appId, Integer operateType) throws BizException;

    /**
     * 更新媒体纬度的贡献配置
     *
     * @param req
     * @return
     */
    int saveOrUpdateContributionConfig(FarmContributionConfigReq req);


    /**
     * 查询贡献配置 媒体纬度
     *
     * @param appId
     * @return
     */
    FarmContributionConfigDto queryContributionConfigByAppId(Long appId);

    /**
     * 提交媒体等级相关财务模型
     * @param req
     * @return
     */
    int saveOrUpdateLevelFinanceConfig(FarmLevelFinanceConfigReq req);

    /**
     * 查询媒体等级相关财务模型
     * @param appId
     * @return
     */
    FarmLevelFinanceConfigDTO queryLevelFinanceConfigByAppId(Long appId);
}
