package cn.com.duiba.tuia.commercial.center.api.constant.common;

import java.util.Objects;

/**
 * 目前的几款留存性活动
 *
 * @author zhangbaiqiang
 * @date 2019-04-24
 */
public enum BizActivityType {

    UNDEFINED(0, "未定义"),
    PLANT(1, "种红包"),
    DIG(2, "挖矿"),
    TREE(3, "种树"),
    FARM(4, "红包农场"),
    SYNTHESIS(5,"合成游戏"),
    MIX(6,"任务中心"),
    RICH_MAN(7,"大富翁"),
    SPREAD(8,"推广活动"),
    TRAVEL(9,"推广活动");

    private Integer type;
    private String desc;

    BizActivityType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDescByType(Integer type) {
        for (BizActivityType typeEnum : values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum.getDesc();
            }
        }
        return null;
    }
}
