package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2020-06-01.
 */

@Getter
@Setter
public class SynMissionDTO implements Serializable {

    private Long id;

    private Integer configVersion;

    @ApiModelProperty(value = "0 未完成, 1已完成")
    private Integer status;

    @ApiModelProperty(value = "当前值")
    private Integer currentNum;

    @ApiModelProperty(value = "任务编号")
    @ExcelRowIndex(0)
    private Long missionId;

    @ApiModelProperty(value = "任务名称")
    @ExcelRowIndex(1)
    private String title;

    @ApiModelProperty(value = "任务种类 1:签到任务 2:历程任务 3:每日任务")
    @ExcelRowIndex(2)
    private Integer missionCat;

    @ApiModelProperty(value = "任务类型(不同类型针对不同字段)")
    @ExcelRowIndex(3)
    private Integer missionType;

    @ApiModelProperty(value = "目标值")
    @ExcelRowIndex(4)
    private Integer targetNum;

    @ApiModelProperty(value = "任务奖励")
    @ExcelRowIndex(5)
    private Long missionPrize;

    @ApiModelProperty(value = "任务奖励系数，可能为空")
    @ExcelRowIndex(6)
    private Integer missionFactor;

    @ApiModelProperty(value = "任务描述")
    @ExcelRowIndex(7)
    private String missionDesc;

    @ApiModelProperty(value = "任务排序")
    @ExcelRowIndex(8)
    private Integer missionOrder;


}
