package cn.com.duiba.tuia.commercial.center.api.dto.travel.config;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 可以选择对类功能进行说明
 * Created by zxw on 2021-08-13.
 */

@Getter
@Setter
public class TravelBuildLevelConfigDTO implements Serializable {

    @ApiModelProperty(value = "建筑ID，关联tb_travel_address.address_code")
    private String cityCode;

    @ApiModelProperty(value = "建筑ID，关联tb_travel_address.address_code")
    private String buildingCode;

    @ApiModelProperty(value = "建筑等级")
    private Integer buildingLevel;

    @ApiModelProperty(value = "升级条件")
    private String upgradeCondition;

    @ApiModelProperty(value = "图鉴url")
    private String photoUrl;

    @ApiModelProperty(value = "产出收益信息json（产出周期(秒)  每日产出次数上限  产出数量  产出收益类型）")
    private String outputAward;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode == null ? null : cityCode.trim();
    }

    public void setBuildingCode(String buildingCode) {
        this.buildingCode = buildingCode == null ? null : buildingCode.trim();
    }

    public void setUpgradeCondition(String upgradeCondition) {
        this.upgradeCondition = upgradeCondition == null ? null : upgradeCondition.trim();
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl == null ? null : photoUrl.trim();
    }

    public void setOutputAward(String outputAward) {
        this.outputAward = outputAward == null ? null : outputAward.trim();
    }

    public UpgradeConditionDO getUpgradeConditionDO() {
        return JSONObject.parseObject(upgradeCondition, UpgradeConditionDO.class);
    }

    public OutputAwardDO getOutputAwardDO() {
        return JSONObject.parseObject(outputAward, OutputAwardDO.class);
    }

    @Setter
    @Getter
    public static class UpgradeConditionDO {

        /**
         * 货币类型 cn.com.duiba.tuia.commercial.center.api.constant.travel.CurrencyTypeEnum
         */
        private Integer currencyType;

        /**
         * 所需数量
         */
        private Long amount;

    }

    @Getter
    @Setter
    public static class OutputAwardDO {

        /**
         * 产出间隔时间 秒
         */
        private Long intervalSecond;

        /**
         * 每日上限
         */
        private Long dailyCeil;

        /**
         * 每日次数上限
         */
        private Long dailyTimesCeil;

        /**
         * 单次收益
         */
        private Long amount;

        /**
         * 产出收益类型 cn.com.duiba.tuia.commercial.center.api.constant.travel.CurrencyTypeEnum
         */
        private Integer awardType;

    }
}
