package cn.com.duiba.tuia.commercial.center.api.remoteservice.commercial.common;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.common.req.CommonWithdrawReq;
import cn.com.duiba.tuia.commercial.center.api.dto.commercial.finance.WithdrawRsp;

/**
 * 通用的提现service
 * Created by zxw on 2021-06-0e.
 */
@AdvancedFeignClient
public interface RemoteCommonWithdrawService {

    /**
     * 校验是否有体现资格
     * @param req
     * @return
     */
    Boolean preWithdraw(CommonWithdrawReq req);

    /**
     * 提现逻辑
     * @param req
     * @return
     */
    WithdrawRsp withdraw(CommonWithdrawReq req) throws BizException;

    /**
     * 查询未完成的订单
     * @param req
     * @return
     */
    String selectOrder(CommonWithdrawReq req);

    /**
     * 插入订单
     * @param req
     * @return
     */
    int insertOrder(CommonWithdrawReq req) throws BizException;
}
