package cn.com.duiba.tuia.commercial.center.api.remoteservice.travel;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.commercial.center.api.dto.common.XMLYAuthenticationDto;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.*;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.config.TravelExchangePrizeDTO;
import cn.com.duiba.tuia.commercial.center.api.dto.travel.req.EntranceActivityRequestDTO;

import java.util.List;

/**
 * @ClassName RemoteTravelService
 * @Description
 * @Author zaizai
 * @Date 2021/8/9 3:21 下午
 */
@AdvancedFeignClient
public interface RemoteTravelService {

    /**
     * 页面初始化
     * @param entranceActivityRequestDTO
     * @throws BizException
     * @return
     */
    TravelInitalizeDTO initialize(EntranceActivityRequestDTO entranceActivityRequestDTO) throws BizException;

    /**
     * 更细用户新手引导步数
     * @param entranceActivityRequestDTO
     * @param stepNumber
     * @throws BizException
     * @return
     */
    Boolean updateUserStep(EntranceActivityRequestDTO entranceActivityRequestDTO, Integer stepNumber) throws BizException;

    /**
     * 切换城市
     * @param entranceActivityRequestDTO
     * @param cityCode
     * @throws BizException
     * @return
     */
    TravelUserCityBuildingDTO switchCity(EntranceActivityRequestDTO entranceActivityRequestDTO, String cityCode) throws BizException;

    /**
     * 升级建筑
     * @param entranceActivityRequestDTO
     * @param buildCode
     * @throws BizException
     * @return
     */
    TravelUserUpgradeBuildDTO upgrade(EntranceActivityRequestDTO entranceActivityRequestDTO, String buildCode) throws BizException;

    /**
     * 获取收益
     * @param entranceActivityRequestDTO
     * @param buildCode
     * @throws BizException
     * @return
     */
    TravelReceiveProfitDTO receiveProfit(EntranceActivityRequestDTO entranceActivityRequestDTO, String buildCode) throws BizException;

    /**
     * 获取这个用户在这个主播下的世界地图
     * @param entranceActivityRequestDTO
     * @return
     * @throws BizException
     */
    List<TravelUserCityDTO> worldMap(EntranceActivityRequestDTO entranceActivityRequestDTO) throws BizException;

    /**
     * 用户建筑等级信息
     * @param entranceActivityRequestDTO
     * @param cityCode
     * @return
     * @throws BizException
     */
    List<TravelUserBuildingLevelDTO> userBuilding(EntranceActivityRequestDTO entranceActivityRequestDTO, String cityCode) throws BizException;

    /**
     * 获取城市建筑资源
     * @param entranceActivityRequestDTO
     * @param cityCode
     * @return
     * @throws BizException
     */
    List<TravelBuildingResourceDTO> buildingsResource(EntranceActivityRequestDTO entranceActivityRequestDTO, String cityCode) throws BizException;

    /**
     * 用户排行榜
     * @param entranceActivityRequestDTO
     * @return
     */
    TravelUserRankInfoDTO userRankInfo(EntranceActivityRequestDTO entranceActivityRequestDTO);

    /**
     * 查询兑换奖励列表
     * @param activityRequestDTO
     * @return
     */
    List<TravelExchangePrizeDTO> userExchangePrizeList(EntranceActivityRequestDTO activityRequestDTO);

    /**
     * 主播排行榜
     * @param activityRequestDTO
     * @return
     */
    TravelAnchorRankInfoDTO anchorRank(EntranceActivityRequestDTO activityRequestDTO);


    /**
     * 获取签名
     * @param url
     * @return
     */
    XMLYAuthenticationDto getSign(String url);



}
