package cn.com.duiba.tuia.commercial.center.api.dto.farm;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.List;

/**
 * [红包农场]抽奖配置
 */
@Getter
@Setter
@SuppressWarnings("serial")
@AllArgsConstructor
@NoArgsConstructor
public class FarmLotteryDto implements Serializable {

    @ApiModelProperty(value = "剩余次数")
    private Integer remain;

    @ApiModelProperty(value = "抽奖奖励")
    private List<FarmLotteryConfigDto> items;

    @ApiModelProperty(value = "初始化次数")
    private Integer initTimes;

    @ApiModelProperty(value = "额外次数列表")
    private List<Integer> extraTimes;

    @ApiModelProperty(value = "已获得的额外次数")
    private Integer extra;

    @ApiModelProperty(value = "当前收获次数")
    private Integer curPickTimes;

    @ApiModelProperty(value = "看视频能获得的次数上限")
    private Integer videoTimes;

    @ApiModelProperty(value = "当前看视频获得的额外次数")
    private Integer curVideoTimes;

}