package cn.com.duiba.tuia.commercial.center.api.dto.farm.excel;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 贡献任务配置
 * Created by zxw on 2021-01-12.
 */
@Getter
@Setter
public class FarmExcelContributionMissionDto {

    @ApiModelProperty(value = "id")
    @ExcelRowIndex
    private Long id;

    @ApiModelProperty(value = "任务内容描述")
    @ExcelRowIndex(1)
    private String missionDesc;

    @ApiModelProperty(value = "任务类型")
    @ExcelRowIndex(2)
    private Integer conditionType;

    @ApiModelProperty(value = "任务需求值")
    @ExcelRowIndex(3)
    private Integer conditionValue;

    @ApiModelProperty(value = "消耗的贡献值")
    @ExcelRowIndex(4)
    private Integer costNum;

    @ApiModelProperty(value = "触发权重")
    @ExcelRowIndex(5)
    private Integer triggerWeight;

    @ApiModelProperty(value = "用户登录N天后可以得到任务")
    @ExcelRowIndex(6)
    private Integer startDay;

    @ApiModelProperty(value = " 插件id")
    @ExcelRowIndex(7)
    private Long pluginId;

    @ApiModelProperty(value = "0 现金 1 虚拟奖品")
    @ExcelRowIndex(8)
    private Integer prizeType;

    @ApiModelProperty(value = "奖励数量")
    @ExcelRowIndex(9)
    private Integer redPacketAmount;

    @ApiModelProperty(value = "奖励内容描述")
    @ExcelRowIndex(10)
    private String prizeDesc;

    @ApiModelProperty(value = "奖品图片")
    @ExcelRowIndex(11)
    private String prizePic;

}
