package cn.com.duiba.tuia.commercial.center.api.dto.farm.req.finance;

import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmActivityUserDto;
import cn.com.duiba.tuia.commercial.center.api.dto.farm.common.FarmBaseUserDto;
import lombok.Data;

import java.io.Serializable;

/**
 * FarmFinanceRewardReq
 * 财务模型计算请求参数
 * @author huangruodan
 * @date 2019-11-26
 */
@Data
public class FarmFinanceRewardReq implements Serializable {

    private static final long serialVersionUID = 1082705430223350418L;

    private FarmBaseUserDto baseUser;

    private FarmActivityUserDto activityUserDto;

    private Long slotId;

    private Long activityId;

    /**
     * 奖励来源  1、土地宝箱 2、风车 3、推车 4、收果实 5、完成任务 6、灌溉 7、离线收益 8、签到 9、打地鼠 10、神秘访客 11、仓库
     */
    private Integer rewardSourceType;

    /**
     * 是否翻倍
     */
    private Boolean isDouble;

    /**
     * 是否是新用户
     */
    private Boolean isNewUser;

    /**
     * 获取 1-A金币 2-B金币 3-C金币
     */
    private Integer detailType;

    private Integer skinVersion;

    /**
     * 是否可以领取新手红包
     */
    private Boolean isNewGift;

    /**
     * 用户签到参数
     */
    private FarmFinanceSignRewardReq sign;

    /**
     * 浇灌参数
     */
    private FarmFinanceWaterRewardReq water;

    /**
     * 设施参数
     */
    private FarmFinanceFacilityRewardReq facility;

    /**
     * 收果实参数
     */
    private FarmFinancePickRewardReq pick;

    /**
     * 任务参数
     */
    private FarmFinanceFinishMissionRewardReq mission;

    /**
     * 用户返回拦截类型
     */
    private Integer userRetType;

    /**
     * 特殊业务标识（用于确定某一特殊的版本定制逻辑，放心修改不会影响其他业务）
     */
    private String specialBusinessFlag;

    /**
     * 是否是一定出红包 不占用常规的开宝箱次数和宝箱红包的次数
     */
    private Boolean isRegularCash;
}
