package cn.com.duiba.tuia.commercial.center.api.dto.travel;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * @ClassName TravelUserBuildingDTO
 * @Description 城市建筑信息
 * @Author zaizai
 * @Date 2021/8/11 9:43 上午
 */
public class TravelUserCityBuildingDTO implements Serializable {

    private static final long serialVersionUID = 3372041784775070009L;

    private Long id;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("关联主播id")
    private Long anchorId;

    @ApiModelProperty("城市code")
    private String cityCode;

    @ApiModelProperty("解锁时间")
    private Long unlockTime;

    @ApiModelProperty("用户解锁状态 0-未解锁 1-已解锁")
    private Integer userLockStatus;

    @ApiModelProperty("城市解锁建筑等级信息")
    private List<TravelUserBuildingLevelDTO> buildingLevels;

    @ApiModelProperty("城市建筑收益信息")
    private List<TravelUserBuildingProfitDTO>  buildingProfits;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getAnchorId() {
        return anchorId;
    }

    public void setAnchorId(Long anchorId) {
        this.anchorId = anchorId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public Long getUnlockTime() {
        return unlockTime;
    }

    public void setUnlockTime(Long unlockTime) {
        this.unlockTime = unlockTime;
    }

    public Integer getUserLockStatus() {
        return userLockStatus;
    }

    public void setUserLockStatus(Integer userLockStatus) {
        this.userLockStatus = userLockStatus;
    }

    public List<TravelUserBuildingLevelDTO> getBuildingLevels() {
        return buildingLevels;
    }

    public void setBuildingLevels(List<TravelUserBuildingLevelDTO> buildingLevels) {
        this.buildingLevels = buildingLevels;
    }

    public List<TravelUserBuildingProfitDTO> getBuildingProfits() {
        return buildingProfits;
    }

    public void setBuildingProfits(List<TravelUserBuildingProfitDTO> buildingProfits) {
        this.buildingProfits = buildingProfits;
    }
}
