package cn.com.duiba.tuia.commercial.center.api.dto.travel.config;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

/**
 * 环游世界兑换奖品表
 */
@Getter
@Setter
@SuppressWarnings("serial")
public class TravelAwardConfigDTO implements Serializable {

    @ApiModelProperty(value = "兑换描述")
    private String exchangeDesc;

    @ApiModelProperty(value = "奖品插件id")
    private Integer pluginId;

    @ApiModelProperty(value = "兑换消耗值")
    private Integer consumeNum;

    @ApiModelProperty(value = "兑换条件")
    private String changeCondition;

    @ApiModelProperty(value = "奖品名称")
    private String awardName;

    @ApiModelProperty(value = "奖励描述")
    private String awardRemark;

    @ApiModelProperty(value = "奖励图片")
    private String awardPic;

    @ApiModelProperty(value = "奖励描述")
    private Integer version;


    @Getter
    @Setter
    public static class ChangeCondition {

        @ApiModelProperty(value = "兑换条件种类")
        private String exchangeCondition;

        @ApiModelProperty(value = "兑换条件目标值")
        private String exchangeValue;
    }
}