package cn.com.duiba.tuia.commercial.center.api.remoteservice.synthesis;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.Date;

/**
 * 合成游戏-测试接口
 *
 * @author lijicong
 * @since 2020-06-02
 */
@AdvancedFeignClient
public interface RemoteSynthesisTestService {

    /**
     * 给用户添加金币
     *
     * @param baseUserId
     * @param coin
     * @return
     * @throws BizException
     */
    boolean addCoin(Long baseUserId, Long coin) throws BizException;

    /**
     * 删除缓存
     *
     * @param activityId
     * @return
     * @throws BizException
     */
    boolean invalidateCache(Long activityId) throws BizException;


    /**
     * 设置用户时间
     * @param baseUserId
     * @param dateStr
     * @return
     * @throws BizException
     */
    Date setDate(Long baseUserId, String dateStr) throws BizException;



    /**
     * 给用户指定等级的宠物
     *
     * @param baseUserId
     * @param activityId
     * @param level
     * @return
     * @throws BizException
     */
    boolean buyForTest(Long baseUserId, Long activityId, Integer level) throws BizException;

}
