package cn.com.duiba.tuia.commercial.center.api.dto.synthesis;

import cn.com.duiba.tuia.activity.center.api.annotation.ExcelRowIndex;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * 当日上线宠物最高等级 DTO
 */
@Setter
@Getter
public class SynConfigOnlineGradeDTO implements Serializable {

    private Long id;

    @ApiModelProperty(value = "配置版本")
    private Integer configVersion;

    @ApiModelProperty(value = "宠物等级")
    @ExcelRowIndex(0)
    private Integer petGrade;

    @ApiModelProperty(value = "非定值金币T")
    @ExcelRowIndex(1)
    private Long variableIncome;

    @ApiModelProperty(value = "常数C1-当日用户解锁次数")
    @ExcelRowIndex(2)
    private Long unlockPetCount;

    @ApiModelProperty(value = "常数C2-普通合成掉落现金次数")
    @ExcelRowIndex(3)
    private Long synDropCashCount;

    @ApiModelProperty(value = "合成掉落礼包区间")
    @ExcelRowIndex(4)
    private String synDropGiftInterval;

    @ApiModelProperty(value = "合成曝光券区间")
    @ExcelRowIndex(5)
    private String synDropCouponInterval;

    @ApiModelProperty(value = "礼包后券区间")
    @ExcelRowIndex(6)
    private String openGiftDropCouponInterval;

    @ApiModelProperty(value = "礼包掉落现金区间")
    @ExcelRowIndex(7)
    private String openGiftDropCashInterval;

    @ApiModelProperty(value = "普通合成礼包上限")
    @ExcelRowIndex(8)
    private Integer normalSynGiftUpper;

    @ApiModelProperty(value = "合成礼包总上限")
    @ExcelRowIndex(9)
    private Integer normalSynGiftAllUpper;

    @ApiModelProperty(value = "合成出券上限")
    @ExcelRowIndex(10)
    private Integer openGiftDropCouponNumUpper;

    @ApiModelProperty(value = "限次活动次数")
    @ExcelRowIndex(11)
    private Integer activityNum;

    @ApiModelProperty(value = "限次抽奖次数")
    @ExcelRowIndex(12)
    private Integer lotteryNum;

    @ApiModelProperty(value = "解锁等级现金比例")
    @ExcelRowIndex(13)
    private Integer unlockCashRatio;

    @ApiModelProperty(value = "合成现金比例")
    @ExcelRowIndex(14)
    private Integer synCashRatio;

    @ApiModelProperty(value = "礼包奖励券上限")
    @ExcelRowIndex(15)
    private Integer giftCouponNumUpper;

    private Date gmtCreate;

    private Date gmtModified;

}
